<?php 
// simple comments

# the pages that utilize this script need to have a <base> element with an href attribute
#   which identifies the url where the directory containing this script is located

# the directory containing this script must be named "simple_comments"

# the included javascript class SimpleComments can be imported from any javascript module
//	import { SimpleComments } from './simple_comments/simple_comments.js';

# and has two modes, the primary mode that shows the comments form and displays comments
//	if (document.querySelector('#page-that-should-show-comments')) {
//		new SimpleComments('.target-that-should-be-commentable[data-id]', '#container-that-should-be-appended-with-comments-and-form');
//	}

# and a list mode that will show indicators for how many comments a target has received
//	else {
//		new SimpleComments('.target-that-should-be-commentable[data-id]', true);
//	}

# when you're not authorized there are generally no links to this script inserted into any page unless you make them
#   you must visit this page by typing in the address directly the first time
#   after you sign in on this page, any page which shows the comment form will show a "Manage comments" link which takes you to this page

# the management secret phrase file should be located in a directory not served by your site
#$management_secret_path = '/path/to/.simple_comments_secret_phrase.txt';
$management_secret_path = '/path/to/.simple_comments_secret_phrase.txt';

$require_approval = true;
$default_name = 'Anonymous';
$forbidden_phrases = [
	
];

# this is a link to view the actual page where a particular comment was left, with "%s" replacing the part of the url which is the target id
#$management_target_uri = 'http://your.site/thalassa_subdirectory_if_you_have_one/view/%s'; # thalassa pattern
#$management_target_uri = 'https://your.site/path_to?some_target_id=%s';
$management_target_uri = 'https://your.site/path_to?some_target_id=%s';

$management_cookie_name = 'simple_comments';



$management_secret = file_get_contents($management_secret_path);

$authorized = false;
if (array_key_exists($management_cookie_name, $_COOKIE) && password_verify($management_secret, $_COOKIE[$management_cookie_name])) {
	$authorized = true;
}

function get_comments_file_path($target_id) {
	return './comments/' . $target_id . '.json';
}

function get_comments_file($comments_file_path) {
	$comments_file = false;
	if (file_exists($comments_file_path)) {
		$comments_file = file_get_contents($comments_file_path);
	}
	return $comments_file;
}

function remove_comment($target_id, $comment_id) {
	$comments_file_path = get_comments_file_path($target_id);
	$comments_file = get_comments_file($comments_file_path);
	if (false === $comments_file) {
		return false;
	}
	$comments = json_decode($comments_file, true);
	$updated_comments = [];
	foreach ($comments as $comment) {
		if ($comment_id != $comment['id']) {
			array_push($updated_comments, $comment);
		}
	}
	file_put_contents($comments_file_path, json_encode($updated_comments));
	return true;
}

function set_approval($target_id, $comment_id, $approval) {
	$comments_file_path = get_comments_file_path($target_id);
	$comments_file = get_comments_file($comments_file_path);
	if (false === $comments_file) {
		return false;
	}
	$comments = json_decode($comments_file, true);
	$updated_comments = [];
	foreach ($comments as $comment) {
		if ($comment_id == $comment['id']) {
			$comment['approved'] = $approval;
		}
		array_push($updated_comments, $comment);
	}
	file_put_contents($comments_file_path, json_encode($updated_comments));
	return true;
}

if ('POST' == $_SERVER['REQUEST_METHOD']) {
	if (array_key_exists('authorize', $_POST)) {
		$cookie_domain = $_SERVER['SERVER_NAME'];
		$cookie_secure = false;
		if ('https' == $_SERVER['REQUEST_SCHEME']) {
			$cookie_secure = true;
		}

		$hash = password_hash($_POST['authorize'], PASSWORD_DEFAULT);
		setcookie(
			$management_cookie_name,
			$hash,
			time() + 63072000,
			'/',
			$cookie_domain,
			$cookie_secure,
			true
		);
		http_response_code(301);
		header('Location: ?');
		exit();
	}
	if (array_key_exists('check_authorized', $_POST)) {
		if (!$authorized) {
			http_response_code(403);
			exit();
		}
		http_response_code(200);
		print('Authorized');
		exit();
	}
	if (!array_key_exists('target_id', $_POST)) {
		http_response_code(400);
		print('No target ID provided');
		exit();
	}
	// target_id must not contain slash or backslash
	if (false !== strpos($_POST['target_id'], '/') || false !== strpos($_POST['target_id'], '\\')) {
		http_response_code(400);
		print('Invalid target ID');
		exit();
	}

	// deleting comment
	if (array_key_exists('comment_id', $_POST)) {
		if (!$authorized) {
			http_response_code(403);
			exit();
		}
		$success = remove_comment($_POST['target_id'], $_POST['comment_id']);
		if (!$success) {
			http_response_code(404);
			print('No comments file for the provided target ID');
			exit();
		}
		http_response_code(200);
		print('Comment removed');
		exit();
	}

	// adding comment
	if (!array_key_exists('comment', $_POST) || '' == $_POST['comment']) {
		http_response_code(400);
		print('No comment provided');
		exit();
	}
	$name = '';
	if (array_key_exists('name', $_POST)) {
		$name = $_POST['name'];
	}
	if ('' == $name) {
		$name = $default_name;
	}

	// create new comment id
	$comment_id = uniqid();

	// compose comment
	$approved = true;
	if ($require_approval) {
		$approved = false;
	}
	$comment = [
		'id' => $comment_id,
		'name' => $name,
		'time' => time(),
		'text' => $_POST['comment'],
		'approved' => $approved,
	];

	$comments_file_path = get_comments_file_path($_POST['target_id']);
	$comments_file = get_comments_file($comments_file_path);

	if (false === $comments_file) {
		$comments = [$comment];
	}
	else {
		$comments = json_decode($comments_file, true);
		array_push($comments, $comment);
	}
	file_put_contents($comments_file_path, json_encode($comments));
	http_response_code(200);
	print(json_encode($comment));
	exit();
}
if ($authorized) {
	$query_array = null;
	parse_str($_SERVER['QUERY_STRING'], $query_array);
	if (array_key_exists('target_id', $query_array) && array_key_exists('comment_id', $query_array)) {
		if (array_key_exists('remove', $query_array)) {
			remove_comment($query_array['target_id'], $query_array['comment_id']);
			header('Location: ?');
			exit();
		}
		elseif (array_key_exists('approve', $query_array)) {
			set_approval($query_array['target_id'], $query_array['comment_id'], true);
			header('Location: ?');
			exit();
		}
		elseif (array_key_exists('unapprove', $query_array)) {
			set_approval($query_array['target_id'], $query_array['comment_id'], false);
			header('Location: ?');
			exit();
		}
	}
	# get all comments
	$all_comments = [];
	$dir = new DirectoryIterator('./comments/');
	foreach ($dir as $fileinfo) {
		if (!$fileinfo->isDot()) {
			$filename = $fileinfo->getFilename();
			$target_id = substr($filename, 0, -5);
			$current_comments = json_decode(file_get_contents('./comments/' . $filename), true);
			foreach ($current_comments as $current_comment) {
				$current_comment['target_id'] = $target_id;
				$all_comments[$current_comment['time'] . $current_comment['id']] = $current_comment;
			}
		}
	}
	krsort($all_comments);
	$table_rows = '';
	foreach ($all_comments as $comment) {
			$target = $comment['target_id'];
			if ('' != $management_target_uri) {
				$target = '<a href="' . sprintf($management_target_uri, $target) . '">' . $target . '</a>';
			}
			$approve = 'approved (<a href="?unapprove&target_id=' . $comment['target_id'] . '&comment_id=' . $comment['id'] . '">revoke</a>)';
			if (!$comment['approved']) {
				$approve = '<a href="?approve&target_id=' . $comment['target_id'] . '&comment_id=' . $comment['id'] . '">approve</a>';
			}
			$table_rows .= '
				<tr>
					<td>' . $target . '</td>
					<td>' . $comment['time'] . '</td>
					<td>' . $comment['name'] . '</td>
					<td>' . htmlentities($comment['text']) . '</td>
					<td>' . $approve . '</td>
					<td><a href="?remove&target_id=' . $comment['target_id'] . '&comment_id=' . $comment['id'] . '">remove</a></td>
				</tr>';
	}
	print('<!DOCTYPE html>
<html>
	<head>
		<title>simple comments</title>
	</head>
	<body>
		<h1>simple comments</h1>
		<h2>management</h2>
		<table border="1">
			<thead>
				<tr>
					<td>Target ID</td>
					<td>Time</td>
					<td>Name</td>
					<td>Comment</td>
					<td>Approve</td>
					<td>Remove</td>
				</tr>
			</thead>
			<tbody>' . $table_rows . '
			</tbody>
		</table>
	</body>
</html>');
}
else {
	print('<!DOCTYPE html>
<html>
	<head>
		<title>simple comments</title>
	</head>
	<body>
		<h1>simple comments</h1>
		<h2>authorization</h2>
		<form method="post">
			<label>Paste your management secret here</label>
			<br/>
			<input type="password" name="authorize"/>
			<br/>
			<input type="submit" value="Authorize"/>
		</form>
	</body>
</html>');
}
 ?>
